create or replace package tbicds.PCK_REPORTS_PI
AUTHID CURRENT_USER 
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
--type defs to return recordsets
  type RetRefCursor is ref cursor;
  type refCursor is ref cursor;

procedure GetPopScoreAvgALLRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nExcludeSiteID         in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
procedure GetPopModuleSeriesRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
    
      pi_nSiteID                in number,
      pi_nMID                   in number,
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*gets population scores*/
procedure GetPopScoreRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
  
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

procedure GetPopScoreAvgRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
procedure GetPopModuleRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
   
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
procedure GetPopSiteIDRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );

procedure GetPopMIDRS (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
     
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2,
      rs                        out RetRefCursor
      );
      
/*load the population module table*/
procedure LoadPopModule (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_nMID                   in number,
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
/*loads a temp table with population matching criteria*/
procedure LoadPopulation (
      pi_vSessionID             in varchar2,
      pi_vSessionClientIP       in varchar2,
      pi_nUserID                in number,
      pi_vKey                   in varchar2,
   
      
      pi_dtFrom                 in date,      
      pi_dtTo                   in date,
      pi_nClinicalSetting       in number,
     
      pi_nRegionID              in number,
      pi_nSiteID                in number,
      pi_nCPATypeID             in number, --type
      
      pi_nImpairmentID          in number,
      pi_nInjuryID              in number,
      pi_vGender                in varchar2,
      pi_nMilStatusID           in number,
      pi_vSiteIDS               in varchar2,
  
      
      po_nStatusCode            out number,
      po_vStatusComment         out varchar2
      );
      
end PCK_REPORTS_PI;
/

